<?php
	// MyBB Open/Close Board Send Admin E-mail plugin code.
	// (C) 2010 CubicleSoft.  All Rights Reserved.
	//
	// This plugin is free to use with the MyBB forum software package.
	// Sends an e-mail to all admins when the board is opened or closed by an admin or a script.
	// Creative Commons License:  http://creativecommons.org/licenses/by-nc-nd/3.0/us
	// Developed by Thomas Hruska, CubicleSoft Core.

	// Disallow direct access to this file for security reasons.
	if (!defined("IN_MYBB"))
	{
		die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
	}

	// Admin hooks.
	$plugins->add_hook("admin_config_settings_change_commit", "OpenCloseBoardEmail_admin_config_settings_change_commit");

	function OpenCloseBoardEmail_info()
	{
		global $lang;

		$lang->load("OpenCloseBoardEmail_plugin_admin");

		return Array(
			"name" => $lang->OpenCloseBoardEmail_plugin_Name,
			"description" => $lang->OpenCloseBoardEmail_plugin_Desc,
			"website" => "http://mods.mybboard.net/view/open-close-board-email",
			"author" => $lang->OpenCloseBoardEmail_plugin_Author,
			"authorsite" => "http://www.cubiclesoft.com/",
			"version" => "1.2",
			"guid" => "2f7e5bba0624196f62d7a33f69e0cdd8",
			"compatibility" => "14*,16*"
		);
	}

	// Extract a list of uids and e-mail addresses of those who have access to the Admin CP.
	// Code shamelessly swiped from /admin/modules/user/admin_permissions.php.
	function OpenCloseBoardEmail_GetAdminList()
	{
		global $db;

		// Get usergroups with ACP access.
		$usergroups = array();
		$query = $db->simple_select("usergroups", "*", "cancp = 1");
		while ($usergroup = $db->fetch_array($query))
		{
			$usergroups[$usergroup["gid"]] = $usergroup;
		}

		// Get users whose primary or secondary usergroup has ACP access.
		$comma = $primary_group_list = $secondary_group_list = "";
		foreach ($usergroups as $gid => $group_info)
		{
			$primary_group_list .= $comma . $gid;
			switch ($db->type)
			{
				case "pgsql":
				case "sqlite3":
				case "sqlite2":
				case "sqlite":  $secondary_group_list .= " OR ','|| u.additionalgroups||',' LIKE '%," . $gid . ",%'";  break;
				default:  $secondary_group_list .= " OR CONCAT(',', u.additionalgroups,',') LIKE '%," . $gid . ",%'";
			}

			$comma = ",";
		}

		$Result = array();
		$sql = "SELECT u.uid, u.email\n";
		$sql .= "FROM " . TABLE_PREFIX . "users u LEFT JOIN " . TABLE_PREFIX . "adminoptions a ON (a.uid = u.uid)\n";
		$sql .= "WHERE u.usergroup IN (" . $primary_group_list . ") " . $secondary_group_list;
		$query = $db->query($sql);
		while ($admin = $db->fetch_array($query))
		{
			$Result[$admin["uid"]] = $admin["email"];
		}

		return $Result;
	}

	function OpenCloseBoardEmail_admin_config_settings_change_commit()
	{
		global $mybb, $db, $lang;

		if (array_key_exists("boardclosed", $mybb->input["upsetting"]) && array_key_exists("boardclosed_reason", $mybb->input["upsetting"]))
		{
			$lang->load("OpenCloseBoardEmail_plugin");

			$Admins = OpenCloseBoardEmail_GetAdminList();
			foreach ($Admins as $uid => $EmailAddr)
			{
				if ($EmailAddr != "")
				{
					if ($mybb->input["upsetting"]["boardclosed"] == 1)
					{
						$Subject = $lang->OpenCloseBoardEmail_BoardClosed_Subject;
						$Message = $lang->sprintf($lang->OpenCloseBoardEmail_BoardClosed_Message, $mybb->input["upsetting"]["boardclosed_reason"]);
					}
					else
					{
						$Subject = $lang->OpenCloseBoardEmail_BoardOpen_Subject;
						$Message = $lang->OpenCloseBoardEmail_BoardOpen_Message;
					}

					my_mail($EmailAddr, $Subject, $Message);
					if ($mybb->settings["mail_logging"] > 0)
					{
						// Mail logging is turned on.  Log the message.
						$insertarray = array(
							"subject" => $db->escape_string($Subject),
							"message" => $db->escape_string($Message),
							"dateline" => TIME_NOW,
							"fromuid" => $mybb->user["uid"],
							"fromemail" => $db->escape_string($mybb->user["email"]),
							"touid" => $uid,
							"toemail" => $db->escape_string($EmailAddr),
							"tid" => 0,
							"ipaddress" => $db->escape_string($mybb->session->ipaddress)
						);
						$db->insert_query("maillogs", $insertarray);
					}
				}
			}
		}
	}
?>